/*
 *
 *  Copyright (C) 2010-2011 Amr Thabet <amr.thabet@student.alx.edu.eg>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to Amr Thabet 
 *  amr.thabet@student.alx.edu.eg
 *
 */
#include "x86emu.h"
dword PELoader(string filename){
      //First we will open the file and read it
      long unsigned int size=0;
      FileMapping* rawdata=OpenFile(filename.c_str());
      //------------
      //begin the PE parsing
      if (rawdata==0)return 0;
      image_header *PEHeader;
      dword FileHandler,PEHeader_ptr;
      image_section_header* data;
      dword imagebase;
      FileHandler=rawdata->BaseAddress;
      if (!(*((short*)FileHandler)==0x5a4d))return 0;
      PEHeader_ptr=((dos_header*)FileHandler)->e_lfanew + FileHandler;
      if (!(*((short*)PEHeader_ptr)==0x4550))return 0;
      PEHeader=(image_header*)PEHeader_ptr;
      size=PEHeader->optional.size_of_image;
      //--------------------
      //preparing the new place

      imagebase=(dword)malloc(size);                          //the virtual place
      memset((char*)imagebase,0,size);
      size=PEHeader->optional.size_of_headers; 
      memcpy((char*)imagebase,(char*)FileHandler,size);
      //----------------------
      //copying the sections
      
      for (int i=0;i <PEHeader->header.number_of_sections;i++){
          dword src =PEHeader->sections[i].pointer_to_raw_data+FileHandler;
          dword dest=PEHeader->sections[i].virtual_address+imagebase;
          size=PEHeader->sections[i].size_of_raw_data;
          //cout << "src = "<<(int*)(src-FileHandler) << "    dest = "<< (int*)(dest-imagebase+0x00400000)<< "   size = "<< (int*)size<< "\n";
          memcpy((char*)dest,(char*)src,size);
          
      };
      CloseFile(rawdata);
      return imagebase; 
};
dword PEDump(dword Eip,Process* c,string filename){
      
      image_header *PEHeader;
      dword FileHandler,PEHeader_ptr;
      image_section_header* data;
      dword imagebase;
      FileHandler=(dword)c->SharedMem->read_virtual_mem(c->GetImagebase());
      if (!(*((short*)FileHandler)==0x5a4d))return 0;
      PEHeader_ptr=((dos_header*)FileHandler)->e_lfanew + FileHandler;
      if (!(*((short*)PEHeader_ptr)==0x4550))return 0;
      PEHeader=(image_header*)PEHeader_ptr;
      dword size=PEHeader->optional.size_of_image;
      for (int i=0;i <PEHeader->header.number_of_sections-1;i++){
          PEHeader->sections[i].size_of_raw_data=PEHeader->sections[i+1].virtual_address-PEHeader->sections[i].virtual_address;
          PEHeader->sections[i].pointer_to_raw_data=PEHeader->sections[i].virtual_address;
          dword size2=PEHeader->sections[i].size_of_raw_data;
          //cout << "Section = "<< i << "\n";
//          cout << "Size = "<<(int*)PEHeader->sections[i].size_of_raw_data << "\n";
//          cout << "Pointer = "<< (int*)PEHeader->sections[i].pointer_to_raw_data << "\n";
      };
      dword index=PEHeader->header.number_of_sections-1;
      PEHeader->sections[index].size_of_raw_data=PEHeader->sections[index].virtual_size;
      PEHeader->sections[index].pointer_to_raw_data=PEHeader->sections[index].virtual_address;
      //cout << "Section = "<< index << "\n";
//      cout << "Size = "<<(int*)PEHeader->sections[index].size_of_raw_data << "\n";
//      cout << "Pointer = "<< (int*)PEHeader->sections[index].pointer_to_raw_data << "\n";

      PEHeader->optional.address_of_entry_point=Eip-c->GetImagebase();
      PEHeader->optional.data_directory[1].virtual_address=0;                      //delete the import table right now to be fixed by
      PEHeader->optional.data_directory[1].size=0;                                 //another program manually
      FileMapping* rawdata=CreateNewFile((const char*)filename.c_str(),(unsigned long)size);
      if (rawdata!=0){ 
         memcpy((char*)rawdata->BaseAddress,(char*)FileHandler,size);
         CloseFile(rawdata);             
      };
};
